/*----------------------------------------------------------------------
 | SEARCH.C                                                     940608
 |
 | Contains all search functions.
 +----------------------------------------------------------------------*/


#include "var.h"


void            PreProcessing(void)
{
    Signed2         i,
                    j;
    BoardIndexType  square;

    ClearPieceSquareTables();
    for (i = A; i <= H; i++) {
        for (j = 1; j <= 8; j++) {
            square = Square(i, j);
            pawnEvalTable[White][square] = centreTable[square] + 6 * j;
            knightEvalTable[White][square] = centreTable[square];
            bishopEvalTable[White][square] = centreTable[square];
            rookEvalTable[White][square] = centreTable[square];
            queenEvalTable[White][square] = centreTable[square];
            kingEvalTable[White][square] = -centreTable[square];

            pawnEvalTable[Black][square] = centreTable[square] + 6 * (9 - j);
            knightEvalTable[Black][square] = centreTable[square];
            bishopEvalTable[Black][square] = centreTable[square];
            rookEvalTable[Black][square] = centreTable[square];
            queenEvalTable[Black][square] = centreTable[square];
            kingEvalTable[Black][square] = -centreTable[square];
        }
    }
    InitPositionalValue();
}                               /* PreProcessing */


Signed2
ItIsADraw(void)
{
    Signed2         i;

    if (nrGamePlies - startHashIndex[nrGamePlies] >= 100) {
        return (True);
    }
    for (i = (Signed2) nrGamePlies - 2; i >= (Signed2) startHashIndex[nrGamePlies];
         i -= 2) {
        if (HashEqual(hashValue[nrGamePlies], hashValue[i])) {
            return (True);
        }
    }
    return (False);
}                               /* ItIsADraw */
